local assets =
{
    Asset("ANIM", "anim/study.zip"),
	Asset("ATLAS", "images/inventoryimages/study_war.xml"),
	Asset("ATLAS", "images/inventoryimages/study_live.xml"),
	Asset("ATLAS", "images/inventoryimages/study_god.xml"),
}
STRINGS.NAMES.STUDY_GOD = "神代研究点数"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STUDY_GOD= "用于研究神代科技的解锁"
STRINGS.NAMES.STUDY_LIVE = "基础研究点数"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STUDY_LIVE= "用于研究基础科技的解锁"
STRINGS.NAMES.STUDY_WAR = "战斗研究点数"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STUDY_WAR= "用于研究战斗科技的解锁"
local function buildgene(le)

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("study")
    inst.AnimState:SetBuild("study")
    inst.AnimState:PlayAnimation(le)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
--分界线
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "study_"..le
    inst.components.inventoryitem.atlasname = "images/inventoryimages/study_"..le..".xml"
    inst:AddComponent("selfstacker")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	inst.Transform:SetScale(1.5, 1.5, 1.5)

    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return Prefab("study_"..le, fn, assets)

end
return 
    buildgene("war"),
	buildgene("live"),
    buildgene("god",true)
	